
<body oncontextmenu="return false;"> <!-- Desativa o clique direito -->
    <style>
        body {
            -webkit-user-select: none; /* Safari */
            -moz-user-select: none; /* Firefox */
            -ms-user-select: none; /* Internet Explorer/Edge */
            user-select: none; /* Non-prefixed version */
        }
    </style>

    <script>
        // Desativar a seleção de texto
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
        });
    </script>
</body>
<?php
// ... Seu PHP original (funções, includes, etc) ...
include "session.php";
if (!(isset($_GET['category_id']) && !isset($_GET['slug']))) {
    include "header.php";
}
include "includes/functions.php";
include "config.php";
// ... Funções utilitárias e lógica original ...
function getXtreamData($endpoint, $params = []) {
    global $get_dns, $username, $password;
    $url = $get_dns . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=" . urlencode($endpoint);
    if (!empty($params)) $url .= '&' . http_build_query($params);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if (curl_errno($ch)) { curl_close($ch); return []; }
    curl_close($ch);
    if ($httpCode !== 200) return [];
    return json_decode($response, true);
}
function decodeBase64IfNeeded($data) {
    if (base64_encode(base64_decode($data, true)) === $data) return base64_decode($data);
    return $data;
}
function formatEPGTime($timestamp) {
    if (is_numeric($timestamp)) {
        if ($timestamp > 10000000000) $timestamp = intval($timestamp / 1000);
        return date('H:i', $timestamp);
    } else {
        $time = strtotime($timestamp);
        if ($time === false) return '00:00';
        return date('H:i', $time);
    }
}
if (isset($_COOKIE['user_timezone'])) {
    $valid_timezones = timezone_identifiers_list();
    $user_timezone = $_COOKIE['user_timezone'];
    if (in_array($user_timezone, $valid_timezones)) date_default_timezone_set($user_timezone);
    else date_default_timezone_set('UTC');
} else {
    date_default_timezone_set('UTC');
    echo '
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                var timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
                document.cookie = "user_timezone=" + timezone + "; path=/; max-age=" + (60*60*24*365);
                location.reload();
            });
        </script>
    ';
    exit();
}

$pagename = "TV Guide";
$logo_url = "assets/img/logo.png";
$id = isset($_GET["id"]) ? $_GET["id"] : null;
$slug = isset($_GET["slug"]) ? $_GET["slug"] : null;
$selectedCategoryId = isset($_GET['category_id']) ? $_GET['category_id'] : null;
if ($slug == "live" && $id !== null) {
    if (isset($_COOKIE["settings_array"])) {
        $SettingArray = json_decode($_COOKIE["settings_array"], true);
        $setting_ext = isset($SettingArray["stream_type"]) ? $SettingArray["stream_type"] : "m3u8";
    } else $setting_ext = "m3u8";
    $video_url = $get_dns . "/live/" . urlencode($username) . "/" . urlencode($password) . "/" . urlencode($id) . "." . $setting_ext;
    $mime_type = "application/x-mpegURL";
    $channel_info_list = getXtreamData('get_live_streams', ['stream_id' => $id]);
    $content_name = "Canal Desconhecido";
    if (!empty($channel_info_list)) {
        foreach ($channel_info_list as $channel_info) {
            if ($channel_info['stream_id'] == $id) {
                $content_name = htmlspecialchars($channel_info['name'], ENT_QUOTES, 'UTF-8');
                break;
            }
        }
    }
    $epg_info = getXtreamData('get_short_epg', ['stream_id' => $id, 'limit' => 10]);
    $epg_data = isset($epg_info['epg_listings']) ? $epg_info['epg_listings'] : [];
}
if (isset($_GET['category_id']) && !isset($_GET['slug'])) {
    $category_id = $_GET['category_id'];
    $channels = getXtreamData('get_live_streams', ['category_id' => $category_id]);
    foreach ($channels as $channel) {
        $stream_id = htmlspecialchars($channel["stream_id"], ENT_QUOTES, 'UTF-8');
        $title = htmlspecialchars($channel["name"], ENT_QUOTES, 'UTF-8');
        $desc_image = htmlspecialchars($channel["stream_icon"], ENT_QUOTES, 'UTF-8');
        echo "<div class='channel-item' onclick='playChannel({$stream_id})'>
                <img src='{$desc_image}' onerror=\"this.onerror=null;this.src='assets/img/logo.png';\" alt='{$title}'/>
                <p>{$title}</p>
              </div>";
    }
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($sitename, ENT_QUOTES, 'UTF-8'); ?> - TV Guide</title>
    <link rel="icon" href="assets/img/favicon.ico" type="image/ico">
    <link href="https://vjs.zencdn.net/7.17.0/video-js.css" rel="stylesheet" />
    <script src="https://vjs.zencdn.net/7.17.0/video.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        html, body {
            box-sizing: border-box;
            min-height: 100%;
            margin: 0;
            padding: 0;
            background: #181824;
            font-family: 'Montserrat', Arial, sans-serif;
            color: #f1f1f1;
        }
        *, *::before, *::after { box-sizing: inherit; }
        body {
            background: linear-gradient(135deg, #23243a 0%, #1b1c24 100%);
            min-height: 100vh;
        }
        .main-flex {
            display: flex;
            flex-direction: row;
            flex-wrap: nowrap;
            gap: 2rem;
            max-width: 1700px;
            margin: 0 auto;
            padding: 2rem 1rem;
            min-height: 100vh;
            align-items: flex-start;
        }
        .category-section, .channel-section, .video-player-column {
            background: rgba(24, 24, 36, 0.92);
            border-radius: 18px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.30);
            padding: 1.2rem 1rem;
            display: flex;
            flex-direction: column;
            min-width: 0;
        }
        .category-section {
            flex: 0 0 260px;
            max-width: 260px;
            min-width: 180px;
            overflow-y: auto;
            height: 80vh;
        }
        .category-section h3 {
            margin: 0 0 1rem 0;
            font-size: 1.1rem;
            color: #e50914;
            font-weight: 700;
            letter-spacing: 0.04em;
        }
        .category-list {
            display: flex;
            flex-direction: column;
            gap: 0.7rem;
        }
        .category-item {
            background: rgba(32, 34, 52, 0.97);
            border-radius: 14px;
            padding: 0.7rem 0.9rem;
            font-size: 1rem;
            font-weight: 500;
            color: #fff;
            cursor: pointer;
            border: 1.5px solid transparent;
            transition: background 0.25s, border 0.25s, transform 0.18s, color 0.25s;
            text-align: left;
        }
        .category-item:hover {
            background: #23243a;
            color: #00ffd0;
            border: 1.5px solid #00ffd0;
            transform: scale(1.04) translateY(-2px);
        }
        .video-player-column {
            flex: 1 1 0;
            max-width: 800px;
            min-width: 340px;
            gap: 1.2rem;
            align-items: stretch;
        }
        .banner-carousel {
            width: 100%;
            margin-bottom: 1rem;
            border-radius: 18px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.30);
            background: #23243a;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            font-weight: 700;
            color: #fff;
            padding: 1.2rem 0;
        }
        .video-player-container {
            width: 100%;
            background: rgba(24, 24, 36, 0.92);
            border-radius: 18px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.30);
            overflow: hidden;
            position: relative;
            min-height: 240px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 1.5px solid rgba(255,255,255,0.08);
        }
        .video-player-logo {
            position: absolute;
            top: 16px;
            right: 22px;
            width: 60px;
            opacity: 0.95;
            z-index: 2;
        }
        .video-info {
            position: absolute;
            top: 16px;
            left: 22px;
            color: #fff;
            font-size: 1.03rem;
            font-weight: 600;
            z-index: 2;
            background: rgba(24,24,36,0.7);
            padding: 6px 12px;
            border-radius: 12px;
        }
        .video-player-placeholder {
            width: 100%;
            min-height: 180px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #aaa;
            font-size: 1.07rem;
            font-weight: 500;
        }
        .back_button {
            position: absolute;
            top: 18px;
            left: 18px;
            background: #23243a;
            padding: 10px;
            cursor: pointer;
            border-radius: 50%;
            text-decoration: none;
            color: #00ffd0;
            font-size: 1.1rem;
            z-index: 5;
            border: 2px solid #00ffd0;
            box-shadow: 0 0 8px #00ffd0;
            transition: background 0.25s, color 0.25s, border 0.25s;
        }
        .back_button:hover {
            background: #181824;
            color: #e50914;
            border: 2px solid #e50914;
        }
        .epg-section {
            background: #23243a;
            border-radius: 18px;
            box-shadow: 0 4px 16px 0 rgba(31, 38, 135, 0.18);
            padding: 1rem 1.2rem;
            color: #fff;
            font-size: 0.97rem;
            margin-top: 1rem;
            width: 100%;
            box-sizing: border-box;
        }
        .epg-section h3 {
            margin: 0 0 0.8rem 0;
            font-size: 1rem;
            font-weight: 700;
            color: #e50914;
        }
        .program-item {
            padding: 8px 0;
            border-bottom: 1px solid rgba(255,255,255,0.08);
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 0.97rem;
        }
        .program-item:last-child { border-bottom: none; }
        .program-title { flex: 1; font-weight: 500; }
        .program-time { flex: 0 0 110px; text-align: right; color: #00ffd0; font-weight: 500; }
        .no-epg { color: #aaa; text-align: center; padding: 12px 0 0 0; }
        .channel-section {
            flex: 0 0 330px;
            max-width: 340px;
            min-width: 200px;
            overflow-y: auto;
            height: 80vh;
        }
        .channel-section h3 {
            margin: 0 0 1rem 0;
            font-size: 1.1rem;
            color: #00ffd0;
            font-weight: 700;
        }
        .channel-list {
            display: flex;
            flex-direction: column;
            gap: 0.7rem;
        }
        .channel-item {
            display: flex;
            align-items: center;
            background: rgba(32, 34, 52, 0.97);
            border-radius: 14px;
            box-shadow: 0 2px 12px 0 rgba(0,0,0,0.10);
            cursor: pointer;
            padding: 0.5rem 0.7rem;
            gap: 0.8rem;
            border: 1.5px solid transparent;
            transition: background 0.25s, border 0.25s, transform 0.18s, color 0.25s;
            position: relative;
            overflow: hidden;
        }
        .channel-item img {
            width: 54px;
            height: 54px;
            object-fit: cover;
            border-radius: 10px;
            box-shadow: 0 2px 8px 0 rgba(0,0,0,0.15);
            background: #23243a;
            border: 2px solid rgba(255,255,255,0.10);
            transition: border 0.25s;
        }
        .channel-item p {
            margin: 0;
            font-size: 1rem;
            font-weight: 500;
            color: #fff;
            flex: 1;
            transition: color 0.25s;
        }
        .channel-item:hover {
            background: #23243a;
            border: 1.5px solid #e50914;
            color: #00ffd0;
            transform: scale(1.03) translateY(-2px);
        }
        .channel-item:hover p { color: #00ffd0; }
        .channel-item:hover img { border: 2px solid #e50914; }
        .category-section::-webkit-scrollbar,
        .channel-section::-webkit-scrollbar,
        .epg-section::-webkit-scrollbar {
            width: 8px;
            background: transparent;
        }
        .category-section::-webkit-scrollbar-thumb,
        .channel-section::-webkit-scrollbar-thumb,
        .epg-section::-webkit-scrollbar-thumb {
            background: rgba(255,255,255,0.10);
            border-radius: 8px;
        }
        /* MOBILE: botão para abrir categorias e overlay */
        #mobileCategoryBtn {
            display: none;
            background: #23243a;
            color: #fff;
            font-size: 1.1rem;
            font-weight: 700;
            border: none;
            border-radius: 12px;
            padding: 0.7rem 1.2rem;
            margin: 1rem 0 0.5rem 0;
            cursor: pointer;
            box-shadow: 0 4px 12px 0 rgba(31,38,135,0.12);
            transition: background 0.2s, color 0.2s;
        }
        #mobileCategoryBtn:hover {
            background: #181824;
            color: #00ffd0;
        }
        #mobileCategoryOverlay {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0; top: 0; right: 0; bottom: 0;
            background: rgba(24,24,36,0.95);
            padding: 0;
            margin: 0;
            align-items: flex-start;
            justify-content: center;
        }
        #mobileCategoryOverlay .mobile-category-content {
            margin: 40px auto 0 auto;
            background: #23243a;
            border-radius: 18px;
            padding: 1.2rem 1rem;
            max-width: 350px;
            width: 90vw;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.30);
            overflow-y: auto; /* Permite rolagem no overlay */
            max-height: 80vh; /* Limite de altura para a rolagem */
        }
        #mobileCategoryOverlay .close-btn {
            background: #23243a;
            border: none;
            color: #fff;
            font-size: 2rem;
            position: absolute;
            right: 20px;
            top: 20px;
            cursor: pointer;
            border-radius: 50%;
            transition: background 0.2s, color 0.2s;
        }
        #mobileCategoryOverlay .close-btn:hover {
            background: #181824;
            color: #e50914;
        }
        @media (max-width: 900px) {
            .main-flex {
                flex-direction: column;
                gap: 1.2rem;
            }
            .category-section { display: none !important; }
            #mobileCategoryBtn { display: block; }
            .channel-section, .video-player-column {
                max-width: 100%;
                min-width: 0;
                padding: 0.8rem 0.5rem;
                height: auto;
            }
        }
    </style>
</head>
<body>
<div class="main-flex">
    <!-- Desktop: Categorias (ESQUERDA) -->
    <div class="category-section">
        <h3>Categorias</h3>
        <div class="category-list" id="category-list-desktop">
            <?php
            $channel_api = getXtreamData('get_live_categories');
            if (!empty($channel_api)) {
                foreach ($channel_api as $category) {
                    $category_id = htmlspecialchars($category['category_id'], ENT_QUOTES, 'UTF-8');
                    $category_name = htmlspecialchars($category['category_name'], ENT_QUOTES, 'UTF-8');
                    echo "<div class='category-item' onclick='loadChannels({$category_id})'>{$category_name}</div>";
                }
            } else {
                echo "<p>Não foram encontradas categorias.</p>";
            }
            ?>
        </div>
    </div>
    <!-- Centro: Player + EPG + Botão categorias mobile -->
    <div class="video-player-column">
        <div class="banner-carousel">
            <i class="fa-solid fa-tv"></i> TV ao Vivo
        </div>
        <div class="video-player-container">
            <?php if ($slug == "live" && $id !== null): ?>
                <a class="back_button" href="tvguide.php">
                    <i class="fa fa-arrow-left"></i>
                </a>
                <div class="video-info">
                    <h2 style="margin:0;font-size:1.03rem;"><?php echo $content_name; ?></h2>
                </div>
                <img src="<?php echo htmlspecialchars($logo_url, ENT_QUOTES, 'UTF-8'); ?>" class="video-player-logo" alt="Logo">
                <video id="videojs-player" class="video-js vjs-default-skin" controls preload="auto" autoplay>
                    <source src="<?php echo htmlspecialchars($video_url, ENT_QUOTES, 'UTF-8'); ?>" type="<?php echo htmlspecialchars($mime_type, ENT_QUOTES, 'UTF-8'); ?>">
                </video>
            <?php else: ?>
                <div class="video-player-placeholder">
                    <p>Selecione um canal para começar a ver.</p>
                </div>
            <?php endif; ?>
        </div>
        <div class="epg-section">
            <h3>Guia de Programas</h3>
            <div id="epg-list">
                <?php if ($slug == "live" && $id !== null): ?>
                    <?php if (!empty($epg_data)): ?>
                        <?php usort($epg_data, function($a, $b) { return strtotime($a['start']) - strtotime($b['start']); }); ?>
                        <?php foreach ($epg_data as $program): ?>
                            <?php
                                $start_timestamp = formatEPGTime($program['start']);
                                $end_timestamp = formatEPGTime($program['end']);
                            ?>
                            <div class="program-item">
                                <div class="program-title"><?php echo htmlspecialchars(decodeBase64IfNeeded($program['title']), ENT_QUOTES, 'UTF-8'); ?></div>
                                <div class="program-time"><?php echo $start_timestamp; ?> a <?php echo $end_timestamp; ?></div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="no-epg">Não há informações sobre o guia de programas disponíveis.</p>
                    <?php endif; ?>
                <?php else: ?>
                    <p class="no-epg">Selecione um canal para ver seu guia de programas.</p>
                <?php endif; ?>
            </div>
        </div>
        <!-- Botão para abrir categorias no mobile -->
        <button id="mobileCategoryBtn" onclick="toggleMobileCategories(true)">
            <i class="fa fa-list"></i> Categorias
        </button>
        <!-- Overlay de categorias no mobile -->
        <div id="mobileCategoryOverlay">
            <div class="mobile-category-content">
                <button class="close-btn" onclick="toggleMobileCategories(false)">&times;</button>
                <h3>Categorias</h3>
                <div class="category-list" id="category-list-mobile">
                    <?php
                    $channel_api = getXtreamData('get_live_categories');
                    if (!empty($channel_api)) {
                        foreach ($channel_api as $category) {
                            $category_id = htmlspecialchars($category['category_id'], ENT_QUOTES, 'UTF-8');
                            $category_name = htmlspecialchars($category['category_name'], ENT_QUOTES, 'UTF-8');
                            echo "<div class='category-item' onclick='loadChannels({$category_id}, true);toggleMobileCategories(false);'>{$category_name}</div>";
                        }
                    } else {
                        echo "<p>Não foram encontradas categorias.</p>";
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <!-- Desktop: Canais (DIREITA) -->
    <div class="channel-section">
        <h3>Canais</h3>
        <div id="channel-list" class="channel-list">
            <?php
            if ($selectedCategoryId !== null) {
                $channels = getXtreamData('get_live_streams', ['category_id' => $selectedCategoryId]);
                if (!empty($channels)) {
                    foreach ($channels as $channel) {
                        $stream_id = htmlspecialchars($channel["stream_id"], ENT_QUOTES, 'UTF-8');
                        $title = htmlspecialchars($channel["name"], ENT_QUOTES, 'UTF-8');
                        $desc_image = htmlspecialchars($channel["stream_icon"], ENT_QUOTES, 'UTF-8');
                        echo "<div class='channel-item' onclick='playChannel({$stream_id})'>
                                <img src='{$desc_image}' onerror=\"this.onerror=null;this.src='assets/img/logo.png';\" alt='{$title}'/>
                                <p>{$title}</p>
                              </div>";
                    }
                } else {
                    echo "<p>Não foram encontrados canais nesta categoria.</p>";
                }
            } else {
                echo '<!-- Os canais serão carregados aqui ao clicar em uma categoria -->';
            }
            ?>
        </div>
    </div>
</div>
<script>
    var selectedCategoryId = <?php echo json_encode($selectedCategoryId); ?> || null;

    function loadChannels(categoryId, isMobile) {
        selectedCategoryId = categoryId;
        var channelList;
        if(window.innerWidth <= 900 || isMobile){
            channelList = document.getElementById('channel-list');
        } else {
            channelList = document.getElementById('channel-list');
        }
        channelList.innerHTML = '<p>Carregando canais...</p>';
        var xhr = new XMLHttpRequest();
        xhr.open('GET', '?category_id=' + encodeURIComponent(categoryId), true);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                channelList.innerHTML = xhr.responseText;
            }
        };
        xhr.send();
    }
    function playChannel(streamId) {
        window.location = 'tvguide.php?id=' + encodeURIComponent(streamId) + '&slug=live&category_id=' + encodeURIComponent(selectedCategoryId);
    }
    function toggleMobileCategories(show) {
        var overlay = document.getElementById('mobileCategoryOverlay');
        if(show) {
            overlay.style.display = "flex";
            overlay.scrollTop = 0; // Reseta a rolagem quando aberto
        } else {
            overlay.style.display = "none";
        }
    }
    <?php if ($slug == "live" && $id !== null): ?>
    var player = videojs('videojs-player', {
        controls: true,
        autoplay: true,
        preload: true,
        fluid: true
    });
    <?php endif; ?>
</script>
</body>
</html>
