<!DOCTYPE html>
<html prefix="og: http://ogp.me/ns#" lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:title" content="MIDIA DIGITAL VS - Streaming Premium" />
    <meta property="og:description"
        content="Milhares de filmes, séries e esportes ao vivo. Aproveite o melhor entretenimento com MIDIA DIGITAL VS" />
    <meta property="og:image" content="https://evopro.sytes.net/images/min.png" />
    <meta property="og:image:secure_url" content="https://evopro.sytes.net/images/min.png" />
    <meta property="og:image:type" content="image/png" />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <meta property="og:type" content="website" />
    <meta property="og:site_name" content="MIDIA DIGITAL VS" />
    <meta property="og:locale" content="pt_BR" />

    <meta name="description"
        content="Streaming de filmes, séries e esportes ao vivo. Planos a partir de R$150. Teste grátis." />
    <meta name="keywords" content="streaming, filmes, séries, TV online, esportes, entretenimento" />
    <meta name="author" content="MIDIA DIGITAL VS" />
    <meta name="theme-color" content="#111827" />

    <link rel="canonical" href="https://midiadigitalvs.com.br" />
    <link rel="icon" type="image/png" href="https://evopro.sytes.net/images/min.png" />
    <link rel="apple-touch-icon" href="https://evopro.sytes.net/images/min.png" />

    <title>MIDIA DIGITAL VS - O melhor streaming de TV, filmes e séries</title>

    <!-- Fontes do Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Biblioteca de animação AOS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css">

    <!-- Tailwind CSS -->
    <link href="https://unpkg.com/tailwindcss@^2/dist/tailwind.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #3b82f6;
            --primary-dark: #1d4ed8;
            --secondary: #f97316;
            --accent: #7c3aed;
            --dark: #111827;
            --light: #f9fafb;
            --netflix-red: #e50914;
            --disney-blue: #0063e5;
            --hbo-purple: #5822b4;
        }

        /* Estilos gerais */
        body {
            font-family: 'Poppins', sans-serif;
            scroll-behavior: smooth;
            overflow-x: hidden;
            background-color: #0f172a;
            color: white;
        }

        .streaming-gradient {
            background: linear-gradient(135deg, #111827 0%, #1f2937 50%, #374151 100%);
        }

        .hero-gradient {
            background: linear-gradient(to bottom, rgba(17, 24, 39, 0.9), rgba(31, 41, 55, 0.95));
        }

        .dark-glass {
            background: rgba(17, 24, 39, 0.7);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        .card-hover {
            transition: all 0.3s ease;
        }

        .card-hover:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.3), 0 10px 10px -5px rgba(0, 0, 0, 0.2);
        }

        .plan-card {
            transition: all 0.4s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .plan-card:hover {
            transform: scale(1.03);
            border-color: var(--primary);
        }

        .plan-popular {
            transform: scale(1.05);
            border: 2px solid var(--primary);
        }

        .feature-icon {
            font-size: 2rem;
            margin-bottom: 1rem;
            background: linear-gradient(135deg, var(--primary), var(--accent));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .btn-glow {
            position: relative;
            overflow: hidden;
            z-index: 1;
        }

        .btn-glow:after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 0.1) 50%, rgba(255, 255, 255, 0) 100%);
            transform: rotate(30deg);
            animation: glow 3s linear infinite;
            z-index: -1;
        }

        @keyframes glow {
            0% {
                transform: translate(-50%, -50%) rotate(0deg);
            }

            100% {
                transform: translate(-50%, -50%) rotate(360deg);
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in {
            animation: fadeIn 0.8s ease forwards;
        }

        .device-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            background: linear-gradient(135deg, var(--primary), var(--accent));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .content-slider {
            scroll-snap-type: x mandatory;
            scrollbar-width: none;
        }

        .content-slide {
            scroll-snap-align: start;
        }

        .content-slider::-webkit-scrollbar {
            display: none;
        }

        /* Efeito de brilho para os bordas */
        .glow-border {
            position: relative;
        }

        .glow-border::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            border-radius: inherit;
            background: linear-gradient(45deg, var(--primary), var(--accent), var(--primary-dark), var(--secondary));
            z-index: -1;
            animation: border-glow 3s linear infinite;
        }

        @keyframes border-glow {
            0% {
                opacity: 0.5;
            }

            50% {
                opacity: 1;
            }

            100% {
                opacity: 0.5;
            }
        }

        /* Contagem regressiva */
        .countdown-container {
            background: linear-gradient(90deg, var(--primary-dark), var(--primary));
        }

        .countdown-time {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(5px);
            border-radius: 6px;
            padding: 0.5rem 0.8rem;
            font-weight: 700;
            min-width: 40px;
            text-align: center;
        }

        /* Melhorias para dispositivos móveis */
        @media (max-width: 768px) {
            body {
                padding-bottom: 60px;
            }

            .countdown-container {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                z-index: 50;
            }

            .back-to-top {
                bottom: 80px !important;
            }
        }

        /* Botão voltar ao topo */
        .back-to-top {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            opacity: 0;
            transition: all 0.3s ease;
            z-index: 100;
        }

        .back-to-top.visible {
            opacity: 1;
        }

        .back-to-top:hover {
            transform: translateY(-5px);
            background: var(--primary-dark);
        }

        /* Correções para navegadores móveis */
        @media (max-width: 768px) {

            /* Garante que o conteúdo se ajuste ao viewport sem rolagem horizontal */
            .container {
                width: 100% !important;
                max-width: 100% !important;
                padding-left: 15px !important;
                padding-right: 15px !important;
                overflow-x: hidden !important;
            }

            /* Correção para a seção hero */
            #inicio .grid {
                width: 100% !important;
                margin-left: 0 !important;
                margin-right: 0 !important;
            }

            /* Evita que qualquer elemento cause overflow horizontal */
            body,
            html {
                overflow-x: hidden !important;
                width: 100% !important;
                position: relative !important;
            }

            /* Melhora para imagens responsivas */
            img {
                max-width: 100% !important;
                height: auto !important;
            }
        }
    </style>
</head>

<body>
    <!-- Barra de progresso de rolagem -->
    <div class="fixed top-0 left-0 h-1 bg-gradient-to-r from-blue-500 via-purple-500 to-blue-500 z-50"
        id="scrollProgress"></div>

    <!-- Navegação -->
    <nav class="dark-glass py-4 sticky top-0 z-40">
        <div class="container mx-auto px-6">
            <div class="flex items-center justify-between">
                <a href="#"
                    class="text-2xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-purple-500">
                    MIDIA DIGITAL VS
                </a>
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#inicio" class="text-gray-300 hover:text-white transition-colors">Início</a>
                    <a href="#conteudo" class="text-gray-300 hover:text-white transition-colors">Conteúdo</a>
                    <a href="#planos" class="text-gray-300 hover:text-white transition-colors">Planos</a>
                    <a href="#dispositivos" class="text-gray-300 hover:text-white transition-colors">Dispositivos</a>
                    <a href="#revendedores" class="text-gray-300 hover:text-white transition-colors">Revendedores</a>
                </div>
                <button onclick="contactarWhatsApp()"
                    class="bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-2 rounded-full hover:shadow-lg transform hover:scale-105 transition duration-300">
                    Teste Grátis
                </button>
            </div>
        </div>
    </nav>

    <!-- Contagem regressiva -->
    <div class="countdown-container py-2 text-white hidden md:block">
        <div class="container mx-auto px-4 flex justify-center items-center gap-3">
            <div>
                <i class="fas fa-bolt text-yellow-300 mr-2"></i>
                <span class="font-bold">OFERTA EXCLUSIVA:</span>
            </div>
            <div class="flex items-center gap-1">
                <span>Termina em</span>
                <div class="flex gap-1">
                    <span id="countHours" class="countdown-time">23</span>
                    <span>:</span>
                    <span id="countMinutes" class="countdown-time">59</span>
                    <span>:</span>
                    <span id="countSeconds" class="countdown-time">59</span>
                </div>
            </div>
            <div>|</div>
            <div>
                <i class="fas fa-tag text-yellow-300 mr-2"></i>
                <span>TESTE GRÁTIS</span>
            </div>
        </div>
    </div>

    <!-- Seção Hero -->
    <section id="inicio" class="relative overflow-hidden pt-16 pb-24 md:py-32">
        <!-- Fundo com sobreposição -->
        <div class="absolute inset-0 z-0">
            <img src="https://evopro.sytes.net/images/magaplux2.jpeg" alt="Fundo de Streaming"
                class="w-full h-full object-cover">
            <div class="absolute inset-0 hero-gradient"></div>
        </div>

        <div class="container mx-auto px-6 relative z-10">
            <div class="grid md:grid-cols-2 gap-16 items-center">
                <div class="space-y-8 animate-fade-in">
                    <span class="inline-block bg-blue-600 text-white text-sm px-4 py-1.5 rounded-full font-medium">
                        ENTRETENIMENTO SEM LIMITES
                    </span>

                    <h1 class="text-5xl md:text-6xl font-bold leading-tight">
                        Todo o <span
                            class="bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-purple-500">entretenimento</span>
                        que você procura
                    </h1>

                    <p class="text-xl text-gray-300">
                        Milhares de filmes, séries, documentários e eventos esportivos ao vivo. Streaming de alta
                        qualidade em todos os seus dispositivos.
                    </p>

                    <div class="flex flex-wrap gap-4 pt-2">
                        <button onclick="contactarWhatsApp()"
                            class="btn-glow bg-gradient-to-r from-blue-600 to-blue-800 hover:from-blue-700 hover:to-blue-900 px-8 py-4 rounded-xl text-white flex items-center gap-2 transform hover:scale-105 transition duration-300 shadow-lg">
                            <i class="fas fa-play-circle text-xl"></i>
                            <span class="font-semibold">Teste GRÁTIS</span>
                        </button>

                        <a href="#planos"
                            class="px-8 py-4 rounded-xl border border-gray-200/30 text-white flex items-center gap-2 hover:bg-white/10 transition">
                            <i class="fas fa-info-circle"></i>
                            <span>Ver planos</span>
                        </a>
                    </div>

                    <div class="flex items-center gap-4">
                        <div class="flex -space-x-2">
                            <div
                                class="w-10 h-10 rounded-full bg-blue-500 flex items-center justify-center text-white border-2 border-gray-900">
                                HD</div>
                            <div
                                class="w-10 h-10 rounded-full bg-purple-500 flex items-center justify-center text-white border-2 border-gray-900">
                                4K</div>
                            <div
                                class="w-10 h-10 rounded-full bg-red-500 flex items-center justify-center text-white border-2 border-gray-900">
                                AO VIVO</div>
                        </div>
                        <span class="text-gray-300">+10.000 usuários satisfeitos</span>
                    </div>
                </div>

                <div class="relative">
                    <div class="glow-border rounded-2xl">
                        <img src="https://evopro.sytes.net/images/megaplux3.jpeg" alt="KRONOSTV"
                            class="rounded-2xl shadow-2xl object-cover">
                    </div>
                    <div class="absolute top-4 right-4 bg-red-600 px-4 py-2 rounded-full font-semibold animate-pulse">
                        Teste GRÁTIS!
                    </div>
                </div>
            </div>

            <!-- Logos e confiança -->
            <div class="mt-24 pt-8 border-t border-gray-700/50">
                <p class="text-center text-gray-400 mb-6 text-sm">CONFIAM EM NÓS</p>
                <div class="flex flex-wrap justify-center items-center gap-8 md:gap-16 opacity-70">
                    <i class="fab fa-apple text-3xl text-gray-400"></i>
                    <i class="fab fa-android text-3xl text-gray-400"></i>
                    <i class="fab fa-amazon text-3xl text-gray-400"></i>
                    <i class="fab fa-chromecast text-3xl text-gray-400"></i>
                    <i class="fab fa-xbox text-3xl text-gray-400"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Características principais -->
    <section class="py-24 streaming-gradient">
        <div class="container mx-auto px-6">
            <div class="text-center mb-16" data-aos="fade-up">
                <span
                    class="inline-block bg-indigo-900/50 text-indigo-300 text-sm px-4 py-1.5 rounded-full font-medium">
                    POR QUE ESCOLHER MIDIA DIGITAL VS
                </span>
                <h2 class="text-4xl font-bold mt-4">A melhor experiência em streaming</h2>
                <p class="text-xl text-gray-300 mt-4 max-w-3xl mx-auto">
                    Aproveite todas as vantagens que só a MIDIA DIGITAL VS pode oferecer
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-gray-900/50 rounded-2xl p-8 card-hover" data-aos="fade-up" data-aos-delay="100">
                    <div class="text-5xl feature-icon">
                        <i class="fas fa-tv"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4">TV ao Vivo</h3>
                    <p class="text-gray-300">
                        Mais de 5.000 canais ao vivo de todo o mundo. Esportes, notícias, entretenimento e muito mais
                        em tempo real.
                    </p>
                </div>

                <div class="bg-gray-900/50 rounded-2xl p-8 card-hover" data-aos="fade-up" data-aos-delay="200">
                    <div class="text-5xl feature-icon">
                        <i class="fas fa-film"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4">Filmes e Séries</h3>
                    <p class="text-gray-300">
                        Uma biblioteca com milhares de títulos atualizados constantemente. Desde os últimos lançamentos
                        até os clássicos de sempre.
                    </p>
                </div>

                <div class="bg-gray-900/50 rounded-2xl p-8 card-hover" data-aos="fade-up" data-aos-delay="300">
                    <div class="text-5xl feature-icon">
                        <i class="fas fa-futbol"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4">Esportes</h3>
                    <p class="text-gray-300">
                        Todos os eventos esportivos importantes. Futebol, basquete, beisebol, NFL, UFC e mais com
                        comentaristas especializados.
                    </p>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-8 mt-12">
                <div class="bg-gray-900/50 rounded-2xl p-6 flex gap-6 items-start card-hover" data-aos="fade-right">
                    <div class="text-3xl feature-icon flex-shrink-0">
                        <i class="fas fa-ban"></i>
                    </div>
                    <div>
                        <h4 class="text-xl font-bold mb-2">Sem Contratos</h4>
                        <p class="text-gray-300">
                            Sem compromissos de longo prazo. Pague pelo tempo que quiser, de um mês a seis meses, e
                            renove apenas se estiver satisfeito.
                        </p>
                    </div>
                </div>

                <div class="bg-gray-900/50 rounded-2xl p-6 flex gap-6 items-start card-hover" data-aos="fade-left">
                    <div class="text-3xl feature-icon flex-shrink-0">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <div>
                        <h4 class="text-xl font-bold mb-2">Múltiplos Dispositivos</h4>
                        <p class="text-gray-300">
                            Aproveite seu conteúdo em até 3 dispositivos simultaneamente, dependendo do seu plano.
                            Compatível com smartphones, tablets, smart TVs e mais.
                        </p>
                    </div>
                </div>
            </div>

            <div class="flex justify-center mt-16">
                <button onclick="contactarWhatsApp()"
                    class="bg-gradient-to-r from-purple-600 to-indigo-600 text-white px-8 py-4 rounded-xl hover:shadow-lg transform hover:scale-105 transition duration-300">
                    Testar Agora
                </button>
            </div>
        </div>
    </section>

    <!-- Slider de Conteúdo -->
    <section id="conteudo" class="py-24 relative overflow-hidden">
        <!-- Decoração de fundo -->
        <div class="absolute inset-0 z-0">
            <div class="absolute inset-0 bg-gradient-to-b from-gray-900 to-black opacity-95"></div>
        </div>

        <div class="container mx-auto px-6 relative z-10">
            <div class="text-center mb-16" data-aos="fade-up">
                <span class="inline-block bg-blue-900/50 text-blue-300 text-sm px-4 py-1.5 rounded-full font-medium">
                    CATÁLOGO EXTENSO
                </span>
                <h2 class="text-4xl font-bold mt-4">Conteúdo Premium</h2>
                <p class="text-xl text-gray-300 mt-4 max-w-3xl mx-auto">
                    Acesse milhares de filmes, séries e eventos esportivos atualizados semanalmente
                </p>
            </div>

            <div class="grid md:grid-cols-2 gap-16 items-center mt-12">
                <div class="space-y-8" data-aos="fade-right">
                    <h3 class="text-3xl font-bold">Filmes e Séries</h3>
                    <p class="text-lg text-gray-300">
                        Desde os últimos lançamentos de Hollywood até produções internacionais. Todos os gêneros
                        disponíveis: ação, drama, comédia, ficção científica, terror e mais.
                    </p>

                    <ul class="space-y-4">
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Atualizações semanais com os últimos lançamentos</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Disponível em áudio original com legendas ou dublado</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Conteúdo em HD e 4K para uma experiência cinematográfica</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Séries completas para maratonar sem limites</span>
                        </li>
                    </ul>
                </div>

                <div class="relative rounded-2xl overflow-hidden" data-aos="fade-left">
                    <img src="https://evopro.sytes.net/images/magaplux2.jpeg" alt="Conteúdo Premium"
                        class="rounded-2xl shadow-2xl">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent"></div>
                    <div class="absolute bottom-4 left-4 right-4 flex justify-between items-center">
                        <div>
                            <span class="text-sm font-semibold bg-red-600 px-2 py-1 rounded">AO VIVO</span>
                            <h4 class="text-xl font-bold mt-1">Lançamentos 2025</h4>
                        </div>
                        <button
                            class="bg-white/20 hover:bg-white/30 rounded-full w-10 h-10 flex items-center justify-center backdrop-blur-sm">
                            <i class="fas fa-play text-white"></i>
                        </button>
                    </div>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-16 items-center mt-24">
                <div class="order-2 md:order-1 relative rounded-2xl overflow-hidden" data-aos="fade-right">
                    <img src="https://evopro.sytes.net/images/magaplux4.jpeg" alt="Esportes ao vivo"
                        class="rounded-2xl shadow-2xl">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent"></div>
                    <div class="absolute bottom-4 left-4 right-4 flex justify-between items-center">
                        <div>
                            <span class="text-sm font-semibold bg-green-600 px-2 py-1 rounded">ESPORTES</span>
                            <h4 class="text-xl font-bold mt-1">Eventos ao vivo</h4>
                        </div>
                        <button
                            class="bg-white/20 hover:bg-white/30 rounded-full w-10 h-10 flex items-center justify-center backdrop-blur-sm">
                            <i class="fas fa-play text-white"></i>
                        </button>
                    </div>
                </div>

                <div class="order-1 md:order-2 space-y-8" data-aos="fade-left">
                    <h3 class="text-3xl font-bold">Esportes ao vivo</h3>
                    <p class="text-lg text-gray-300">
                        Não perca nenhum jogo. Transmissões ao vivo dos eventos esportivos mais importantes do mundo
                        com a melhor qualidade.
                    </p>

                    <ul class="space-y-4">
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Futebol: Champions League, Premier League, LaLiga, Serie A, Bundesliga e mais</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Basquete: NBA, Euroliga e competições internacionais</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Eventos de UFC, Fórmula 1, NFL, MLB e todos os esportes importantes</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Comentaristas profissionais e múltiplos ângulos de câmera</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Planos e Preços -->
    <section id="planos" class="py-24 streaming-gradient">
        <div class="container mx-auto px-6">
            <div class="text-center mb-16" data-aos="fade-up">
                <span class="inline-block bg-green-900/50 text-green-300 text-sm px-4 py-1.5 rounded-full font-medium">
                    PREÇOS ACESSÍVEIS
                </span>
                <h2 class="text-4xl font-bold mt-4">Planos para todos</h2>
                <p class="text-xl text-gray-300 mt-4 max-w-3xl mx-auto">
                    Escolha o plano que melhor se adapta às suas necessidades
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <!-- Plano Básico -->
                <div class="plan-card bg-gray-900/60 rounded-2xl p-8 relative" data-aos="fade-up" data-aos-delay="100">
                    <div class="space-y-4">
                        <h3 class="text-2xl font-bold">Básico</h3>
                        <div class="text-4xl font-bold">R$150<span class="text-lg text-gray-400">/mês</span></div>
                        <p class="text-gray-400 pb-4">Ideal para usuários individuais</p>
                    </div>

                    <div class="border-t border-gray-700 my-6"></div>
                    <ul class="space-y-4 mb-12">
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Streaming em HD</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>1 dispositivo</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Filmes e Séries</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>TV ao vivo</span>
                        </li>
                    </ul>

                    <button onclick="contactarWhatsApp()"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white py-3 rounded-xl transition duration-300">
                        Escolher Plano
                    </button>
                </div>

                <!-- Plano Premium -->
                <div class="plan-card plan-popular bg-gray-900/80 rounded-2xl p-8 relative z-10" data-aos="fade-up"
                    data-aos-delay="200">
                    <div class="absolute -top-4 left-0 right-0 flex justify-center">
                        <span
                            class="bg-gradient-to-r from-yellow-500 to-yellow -600 text-black px-4 py-1 rounded-full text-sm font-bold">
                            MAIS POPULAR
                        </span>
                    </div>

                    <div class="space-y-4">
                        <h3 class="text-2xl font-bold">Premium</h3>
                        <div class="text-4xl font-bold">R$360<span class="text-lg text-gray-400">/3 meses</span></div>
                        <p class="text-gray-400 pb-4">Perfeito para casais e famílias</p>
                    </div>

                    <div class="border-t border-gray-700 my-6"></div>

                    <ul class="space-y-4 mb-12">
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Streaming em HD e 4K</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>3 dispositivos simultâneos</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Conteúdo exclusivo</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Esportes ao vivo premium</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Canais para adultos (opcional)</span>
                        </li>
                    </ul>

                    <button onclick="contactarWhatsApp()"
                        class="w-full bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white py-3 rounded-xl transition duration-300 transform hover:scale-105">
                        Escolher Plano
                    </button>
                </div>

                <!-- Plano Familiar -->
                <div class="plan-card bg-gray-900/60 rounded-2xl p-8 relative" data-aos="fade-up" data-aos-delay="300">
                    <div class="space-y-4">
                        <h3 class="text-2xl font-bold">Familiar</h3>
                        <div class="text-4xl font-bold">R$600<span class="text-lg text-gray-400">/6 meses</span></div>
                        <p class="text-gray-400 pb-4">A melhor opção a longo prazo</p>
                    </div>

                    <div class="border-t border-gray-700 my-6"></div>

                    <ul class="space-y-4 mb-12">
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Streaming em HD e 4K</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>3 dispositivos simultâneos</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Conteúdo exclusivo</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Todos os esportes ao vivo</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Canais para adultos (opcional)</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check text-green-500"></i>
                            <span>Suporte prioritário 24/7</span>
                        </li>
                    </ul>

                    <button onclick="contactarWhatsApp()"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white py-3 rounded-xl transition duration-300">
                        Escolher Plano
                    </button>
                </div>
            </div>

            <div class="mt-16 text-center" data-aos="fade-up">
                <p class="text-lg text-gray-300 mb-6">
                    Não tem certeza de qual plano escolher? Comece com um teste gratuito.
                </p>
                <button onclick="contactarWhatsApp()"
                    class="bg-gradient-to-r from-green-500 to-emerald-700 text-white px-8 py-4 rounded-xl hover:shadow-lg transform hover:scale-105 transition duration-300">
                    </i> Obter teste gratuito
                </button>
            </div>
        </div>
    </section>

    <!-- Dispositivos compatíveis -->
    <section id="dispositivos" class="py-24 relative overflow-hidden">
        <!-- Decoração de fundo -->
        <div class="absolute inset-0 z-0">
            <div class="absolute inset-0 bg-gradient-to-b from-gray-900 to-black opacity-95"></div>
        </div>

        <div class="container mx-auto px-6 relative z-10">
            <div class="text-center mb-16" data-aos="fade-up">
                <span class="inline-block bg-red-900/50 text-red-300 text-sm px-4 py-1.5 rounded-full font-medium">
                    MÁXIMA COMPATIBILIDADE
                </span>
                <h2 class="text-4xl font-bold mt-4">Em todos os seus dispositivos</h2>
                <p class="text-xl text-gray-300 mt-4 max-w-3xl mx-auto">
                    Aproveite MIDIA DIGITAL VS em qualquer tela, a qualquer momento
                </p>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover" data-aos="fade-up"
                    data-aos-delay="100">
                    <div class="device-icon">
                        <i class="fas fa-tv"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Smart TV</h3>
                    <p class="text-gray-400">
                        Samsung, LG, Sony, Android TV, Fire TV
                    </p>
                </div>

                <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover" data-aos="fade-up"
                    data-aos-delay="200">
                    <div class="device-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Smartphones</h3>
                    <p class="text-gray-400">
                        iOS, Android, Windows Phone
                    </p>
                </div>

                <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover" data-aos="fade-up"
                    data-aos-delay="300">
                    <div class="device-icon">
                        <i class="fas fa-tablet-alt"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Tablets</h3>
                    <p class="text-gray-400">
                        iPad, tablets Android, Kindle
                    </p>
                </div>

                <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover" data-aos="fade-up"
                    data-aos-delay="400">
                    <div class="device-icon">
                        <i class="fas fa-laptop"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Computadores</h3>
                    <p class="text-gray-400">
                        Windows, Mac, Linux, navegadores web
                    </p>
                </div>
            </div>

            <div class="mt-16 text-center max-w-3xl mx-auto" data-aos="fade-up">
                <div class="bg-gray-800/30 p-6 rounded-2xl border border-gray-700">
                    <h3 class="text-2xl font-bold mb-4">App MIDIA DIGITAL VS</h3>
                    <p class="text-gray-300 mb-6">
                        Baixe nosso aplicativo para uma experiência otimizada. Disponível para dispositivos
                        Android.
                    </p>
                    <div class="flex justify-center">
                        <a href="https://aftv.news/4442387" download
                            class="flex items-center gap-2 bg-black hover:bg-gray-900 text-white px-6 py-3 rounded-xl border border-gray-700 transition transform hover:scale-105">
                            <i class="fab fa-android text-2xl"></i>
                            <div class="text-left">
                                <div class="text-xs">Disponível para</div>
                                <div class="text-lg font-semibold">Android</div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Revendedores -->
    <section id="revendedores" class="py-24 streaming-gradient">
        <div class="container mx-auto px-6">
            <div class="grid md:grid-cols-2 gap-12 items-center">
                <div class=" space-y-8" data-aos="fade-right">
                    <span
                        class="inline-block bg-purple-900/50 text-purple-300 text-sm px-4 py-1.5 rounded-full font-medium">
                        OPORTUNIDADE DE NEGÓCIO
                    </span>

                    <h2 class="text-4xl font-bold">Programa de Revendedores</h2>

                    <p class="text-xl text-gray-300">
                        Gere renda extra revendendo nosso serviço. Faça parte da revolução do streaming.
                    </p>

                    <ul class="space-y-4">
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Comissões atraentes de até 300%</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Painel de controle intuitivo para gerenciar clientes</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Suporte técnico prioritário 24/7</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Materiais de marketing e treinamento incluídos</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fas fa-check-circle text-green-500 mt-1"></i>
                            <span>Sem investimento inicial significativo</span>
                        </li>
                    </ul>

                    <button onclick="contactarWhatsApp()"
                        class="bg-gradient-to-r from-purple-600 to-indigo-600 text-white px-8 py-4 rounded-xl hover:shadow-lg transform hover:scale-105 transition duration-300">
                        <i class="fas fa-handshake mr-2"></i> Tornar-se Revendedor
                    </button>
                </div>

                <div class="relative" data-aos="fade-left">
                    <div class="grid grid-cols-2 gap-6">
                        <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover">
                            <div
                                class="text-4xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-green-400 to-emerald-500 mb-2">
                                300%
                            </div>
                            <p class="text-lg">Comissão</p>
                        </div>

                        <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover">
                            <div
                                class="text-4xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-indigo-500 mb-2">
                                24/7
                            </div>
                            <p class="text-lg">Suporte</p>
                        </div>

                        <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover">
                            <div
                                class="text-4xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-yellow-400 to-amber-500 mb-2">
                                Flex
                            </div>
                            <p class="text-lg">Seu próprio preço</p>
                        </div>

                        <div class="bg-gray-800/50 rounded-2xl p-6 text-center card-hover">
                            <div
                                class="text-4xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-red-400 to-pink-500 mb-2">
                                $$$
                            </div>
                            <p class="text-lg">Renda extra</p>
                        </div>
                    </div>

                    <div class="mt-8 p-8 bg-gray-800/50 rounded-2xl">
                        <h3 class="text-2xl font-bold mb-4">Preços para revendedores</h3>
                        <div class="space-y-4">
                            <div class="flex justify-between items-center border-b border-gray-700 pb-2">
                                <span>25 Créditos</span>
                                <span class="font-bold">R$400</span>
                            </div>
                            <div class="flex justify-between items-center border-b border-gray-700 pb-2">
                                <span>50 Créditos</span>
                                <span class="font-bold">R$700</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span>300 Créditos + app personalizada</span>
                                <span class="font-bold">R$1.000</span>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Depoimentos -->
    <section class="py-24 relative overflow-hidden">
        <!-- Decoração de fundo -->
        <div class="absolute inset-0 z-0">
            <div class="absolute inset-0 bg-gradient-to-b from-gray-900 to-black opacity-95"></div>
        </div>

        <div class="container mx-auto px-6 relative z-10">
            <div class="text-center mb-16" data-aos="fade-up">
                <span class="inline-block bg-blue-900/50 text-blue-300 text-sm px-4 py-1.5 rounded-full font-medium">
                    CLIENTES SATISFEITOS
                </span>
                <h2 class="text-4xl font-bold mt-4">O que dizem nossos usuários</h2>
                <p class="text-xl text-gray-300 mt-4 max-w-3xl mx-auto">
                    Milhares de pessoas já desfrutam do KRONOSTV em todo o mundo
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-gray-900/50 rounded-2xl p-8 card-hover" data-aos="fade-up" data-aos-delay="100">
                    <div class="flex text-yellow-500 mb-4">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-gray-300 italic mb-8">
                        "Serviço incrível. A qualidade da imagem é excelente e eles têm todos os canais esportivos que
                        eu queria. O app funciona perfeitamente na minha Smart TV."
                    </p>
                    <div class="flex items-center">
                        <div
                            class="w-12 h-12 rounded-full bg-blue-600 flex items-center justify-center text-xl font-bold">
                            JL
                        </div>
                        <div class="ml-4">
                            <h4 class="font-semibold">Juan López</h4>
                            <p class="text-sm text-gray-400">Usuário desde 2022</p>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-900/50 rounded-2xl p-8 card-hover" data-aos="fade-up" data-aos-delay="200">
                    <div class="flex text-yellow-500 mb-4">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-gray-300 italic mb-8">
                        "Comecei como usuário e agora sou revendedor. O suporte técnico é excelente e meus clientes
                        estão encantados com o serviço. Negócio rentável e fácil de gerenciar."
                    </p>
                    <div class="flex items-center">
                        <div
                            class="w-12 h-12 rounded-full bg-purple-600 flex items-center justify-center text-xl font-bold">
                            MR
                        </div>
                        <div class="ml-4">
                            <h4 class="font-semibold">María Rodríguez</h4>
                            <p class="text-sm text-gray-400">Revendedora</p>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-900/50 rounded-2xl p-8 card-hover" data-aos="fade-up" data-aos-delay="300">
                    <div class="flex text-yellow-500 mb-4">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star-half-alt"></i>
                    </div>
                    <p class="text-gray-300 italic mb-8">
                        "Fantástico catálogo de filmes e séries. A possibilidade de vê-los em vários dispositivos ao
                        mesmo tempo é genial para toda a família. Relação qualidade-preço imbatível."
                    </p>
                    <div class="flex items-center">
                        <div
                            class="w-12 h-12 rounded-full bg-green-600 flex items-center justify-center text-xl font-bold">
                            PG
                        </div>
                        <div class="ml-4">
                            <h4 class="font-semibold">Pedro García</h4>
                            <p class="text-sm text-gray-400"> Plano Familiar</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Final -->
    <section class="py-20 streaming-gradient">
        <div class="container mx-auto px-6">
            <div class="max-w-4xl mx-auto text-center" data-aos="fade-up">
                <span class="inline-block bg-white/10 text-white text-sm px-4 py-1.5 rounded-full font-medium mb-6">
                    COMEÇE HOJE MESMO
                </span>

                <h2 class="text-4xl md:text-5xl font-bold mb-8">
                    Junte-se à revolução do entretenimento
                </h2>

                <p class="text-xl text-gray-300 mb-12 max-w-3xl mx-auto">
                    Todo o conteúdo que você ama, em todas as suas telas, a um preço imbatível. Sem contratos, sem
                    compromissos.
                </p>

                <div class="flex flex-col md:flex-row items-center justify-center gap-6">
                    <button onclick="contactarWhatsApp()"
                        class="btn-glow bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white px-8 py-4 rounded-xl flex items-center gap-2 transform hover:scale-105 transition duration-300 w-full md:w-auto">
                        <i class="fas fa-play-circle text-xl"></i>
                        <span class="font-semibold">Teste GRÁTIS</span>
                    </button>

                    <button onclick="contactarWhatsApp()"
                        class="bg-white/10 hover:bg-white/20 border border-white/30 text-white px-8 py-4 rounded-xl flex items-center gap-2 transition w-full md:w-auto">
                        <i class="fas fa-info-circle"></i>
                        <span>Mais informações</span>
                    </button>
                </div>

                <div class="mt-8 p-4 bg-gray-900/30 rounded-lg inline-block">
                    <p class="text-gray-400 text-sm">
                        <i class="fas fa-shield-alt text-green-500 mr-2"></i> Pagamento seguro garantido | Suporte 24/7 |
                        Cancelamento a qualquer momento
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Contagem regressiva móvel -->
    <div class="fixed bottom-0 left-0 right-0 md:hidden countdown-container py-3 z-50">
        <div class="container mx-auto px-4 flex flex-col items-center">
            <p class="text-sm mb-1">Oferta especial termina em:</p>
            <div class="flex gap-1">
                <span id="mobileCountHours" class="countdown-time text-sm">23</span>
                <span>:</span>
                <span id="mobileCountMinutes" class="countdown-time text-sm">59</span>
                <span>:</span>
                <span id="mobileCountSeconds" class="countdown-time text-sm">59</span>
            </div>
        </div>
    </div>

    <!-- Botão de contato flutuante móvel -->
    <div class="fixed bottom-16 right-4 md:hidden z-50">
        <button onclick="contactarWhatsApp()"
            class="bg-gradient-to-r from-green-500 to-emerald-600 text-white w-14 h-14 rounded-full shadow-lg flex items-center justify-center">
            <i class="fab fa-whatsapp text-2xl"></i>
        </button>
    </div>

    <!-- Rodapé -->
    <footer class="bg-gray-900 text-white py-16">
        <div class="container mx-auto px-6">
            <div class="grid grid-cols-2 md:grid-cols-2 gap-8 mb-12">
                <div>
                    <h3 class="text-xl font-bold mb-4">MIDIA DIGITAL VS</h3>
                    <ul class="space-y-2">
                        <li><a href="#inicio" class="text-gray-400 hover:text-white transition-colors">Início</a></li>
                        <li><a href="#conteudo" class="text-gray-400 hover:text-white transition-colors">Conteúdo</a>
                        </li>
                        <li><a href="#planos" class="text-gray-400 hover:text-white transition-colors">Planos</a></li>
                        <li><a href="#dispositivos"
                                class="text-gray-400 hover:text-white transition-colors">Dispositivos</a></li>
                        <li><a href="#revendedores"
                                class="text-gray-400 hover:text-white transition-colors">Revendedores</a </li>
                    </ul>
                </div>

                <div>
                    <h3 class="text-xl font-bold mb-4">Contato</h3>
                    <a href="javascript:contactarWhatsApp()"
                        class="bg-gradient-to-r from-green-500 to-emerald-600 text-white px-6 py-2 rounded-lg flex items-center justify-center gap-2 mb-4 hover:shadow-lg transition">
                        <i class="fab fa-whatsapp"></i>
                        <span>WhatsApp</span>
                    </a>
                </div>
            </div>

            <div class="border-t border-gray-800 pt-8 text-center">
                <p class="text-gray-500 text-sm">
                    &copy; 2025 KRONOSTV. Todos os direitos reservados.
                </p>
            </div>
        </div>
    </footer>

    <!-- Botão voltar ao topo -->
    <div class="back-to-top" id="backToTop">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- Biblioteca de animação AOS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"></script>

    <script>
        // Inicializar AOS
        document.addEventListener('DOMContentLoaded', function () {
            AOS.init({
                duration: 800,
                once: true,
                offset: 100
            });
        });

        // Contador regressivo
        function updateCountdown() {
            let hours = 23;
            let minutes = 59;
            let seconds = 59;

            function updateTime() {
                if (seconds > 0) {
                    seconds--;
                } else {
                    seconds = 59;
                    if (minutes > 0) {
                        minutes--;
                    } else {
                        minutes = 59;
                        if (hours > 0) hours--;
                    }
                }

                // Atualizar contadores desktop e móvel
                document.getElementById('countHours').textContent = String(hours).padStart(2, '0');
                document.getElementById('countMinutes').textContent = String(minutes).padStart(2, '0');
                document.getElementById('countSeconds').textContent = String(seconds).padStart(2, '0');

                // Também atualizar contadores móveis
                if (document.getElementById('mobileCountHours')) {
                    document.getElementById('mobileCountHours').textContent = String(hours).padStart(2, '0');
                    document.getElementById('mobileCountMinutes').textContent = String(minutes).padStart(2, '0');
                    document.getElementById('mobileCountSeconds').textContent = String(seconds).padStart(2, '0');
                }
            }

            // Atualizar a cada segundo
            setInterval(updateTime, 1000);
        }

        // Contatar pelo WhatsApp
        function contactarWhatsApp() {
            const mensagem = "Olá! Estou interessado no MIDIADIGITALVS. Gostaria de mais informações para realizar meu teste gratuito.";
            const numero = "92993970584";
            window.open(`https://wa.me/${numero}?text=${encodeURIComponent(mensagem)}`);
        }

        // Barra de progresso de rolagem
        window.addEventListener('scroll', () => {
            const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
            const scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
            const clientHeight = document.documentElement.clientHeight || document.body.clientHeight;

            const scrollPercentage = (scrollTop / (scrollHeight - clientHeight)) * 100;
            document.getElementById('scrollProgress').style.width = scrollPercentage + '%';

            // Mostrar/ocultar botão "voltar ao topo"
            if (scrollTop > 300) {
                document.getElementById('backToTop').classList.add('visible');
            } else {
                document.getElementById('backToTop').classList.remove('visible');
            }
        });

        // Voltar ao topo
        document.getElementById('backToTop').addEventListener('click', () => {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Rolagem suave para links internos
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();

                const targetId = this.getAttribute('href');
                if (targetId === '#') return;

                const targetElement = document.querySelector(targetId);
                if (targetElement) {
                    targetElement.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Iniciar funções ao carregar a página
        updateCountdown();
    </script>
</body>

</html>